﻿var notificationPage = {
    context: $(".v-notification"),
    datatable: null,
    initializeDataTable: function () {
        var toolBarItems = [
          { "Action": "Read", "Label": resources.MarkAsRead, "DisplayCondition": function (data) { return data.ReadDate == null; } },
          { "Action": "UnRead", "Label": resources.MarkAsUnread, "DisplayCondition": function (data) { return data.ReadDate == null; } },
          { "Action": "Delete", "Label": resources.Delete }
        ];

        this.datatable = $(".v-notificationTable", this.context).a4datatable({
            height: "full",
            stateKey: "NotificationList",
            allowRowSelection: true,
            displaySearchBox: false,
            displayColumnSelector: true,
            ajaxAction: a4.getAction("GetNotifications", "SystemNotification", "SystemNotification"),
            defaultSorting: "Name",
            advancedFilter: false,
            columns: [
                { "Title": resources.Type, "Name": "GroupName", "Data": "GroupName" },
                { "Title": resources.Event, "Name": "Name", "Data": "Type" },
                { "Title": resources.Date, "Name": "CreationDate" },
                { "Title": resources.Details, "Name": "Detail" },
                { "Name": "ReadDate", "Title": resources.ReadDate, "Data": "ReadDate", "Type": "datetime", "DefaultValue": "" }
            ],
            contextMenuItems: notificationPage.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "showDetails":
                        modalDialog.showWindow(a4.getAction("Details", "SystemNotification", "SystemNotification", { notificationId: row.Id }),
                            300, 700, {
                                afterClose: function () {
                                    notificationPage.refreshDataTable();
                                }
                            });
                        break;
                    case "delete":
                        notificationPage.deleteItems(row.Id);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.IsRead, "AjaxParams": { "ReadDate": "IsNotNull" } },
                    { "Label": resources.UnRead, "AjaxParams": { "ReadDate": "IsNull" } }
                ]
            },
            localizableTexts: { "All": resources.AllNotifications, "Search": resources.SearchNotifications },
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "Read":
                        notificationPage.SetNotificationRead(ids);
                        break;
                    case "UnRead":
                        notificationPage.SetNotificationUnRead(ids);
                        break;
                    case "Delete":
                        notificationPage.deleteItems(ids);
                        break;
                }
            },
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteResources, function () {
            a4.callServerMethod(a4.getAction("DeleteSubscriberNotification", "SystemNotification", "SystemNotification"), { notificationIds: items },
                function (result) {
                    notificationPage.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    getContextMenuItems: function () {
        var items = [{ "Action": "showDetails", "Label": resources.ViewDetails },
                     { "Action": "delete", "Label": resources.Delete }];

        return items;
    },
    refreshDataTable: function () {
        this.datatable.a4datatable("refresh");

        a4.updateUnreadNotificationsCount();
    },
    initialize: function () {
        notificationPage.initializeDataTable();
    },
    SetNotificationRead: function (ids) {
        a4.callServerMethod(a4.getAction("SetNotificationRead", "SystemNotification", "SystemNotification", { notificationIds: ids }), null,
            function (result) {
                notificationPage.refreshDataTable();
            }
        );
    },
    SetNotificationUnRead: function (ids) {
        a4.callServerMethod(a4.getAction("SetNotificationUnRead", "SystemNotification", "SystemNotification", { notificationIds: ids }), null,
            function (result) {
                notificationPage.refreshDataTable();
            }
        );
    }
}

$(document).ready(function () {
    if (notificationPage.context.length > 0) {
        notificationPage.initialize();
    }
});